/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.tables.VWFieldNameCellEditor;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class VWDataFieldNameCellEditor
extends VWFieldNameCellEditor
implements TableCellEditor {
    public VWDataFieldNameCellEditor(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.m_authPropertyData != null && this.m_combo != null) {
            this.m_combo.removeAllItems();
            Object[] fieldDefs = this.m_authPropertyData.getFields();
            if (fieldDefs != null && fieldDefs.length > 0) {
                try {
                    VWQubbleSort.sort(fieldDefs);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                for (int nIndex = 0; nIndex < fieldDefs.length; ++nIndex) {
                    String name;
                    if (fieldDefs[nIndex] == null || (name = ((VWFieldDefinition)fieldDefs[nIndex]).getName()) == null || name.startsWith("F_") || !this.isDataField((VWFieldDefinition)fieldDefs[nIndex])) continue;
                    this.m_combo.addItem(((VWFieldDefinition)fieldDefs[nIndex]).isArray() ? name + "[]" : name);
                }
            }
            this.m_combo.setSelectedIndex(-1);
        }
        if (value != null && value instanceof String) {
            this.setValue(value);
        }
        return this.m_combo;
    }

    protected boolean isDataField(VWFieldDefinition fieldDef) {
        try {
            switch (fieldDef.getFieldType()) {
                case 32: 
                case 64: 
                case 128: {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }
}

